ALTER TABLE ejf_section ADD filter VARCHAR2(10);
ALTER TABLE ejf_section ADD caton CHAR(1) DEFAULT 'T';
ALTER TABLE ejf_section ADD ruleon CHAR(1) DEFAULT 'T';
ALTER TABLE ejf_section ADD logo VARCHAR2(100);
ALTER TABLE ejf_section ADD showHotlinks VARCHAR2(10);
ALTER TABLE ejf_section ADD hotlinkRows NUMBER(4) DEFAULT 8;
ALTER TABLE ejf_section ADD isOnBoard CHAR(1) DEFAULT 'F';
ALTER TABLE ejf_section ADD imageMode CHAR(1) DEFAULT 'P';
ALTER TABLE ejf_section ADD imageFile VARCHAR2(255);
ALTER TABLE ejf_section ADD imageLink VARCHAR2(255);
ALTER TABLE ejf_section ADD imageTitle VARCHAR2(255);
ALTER TABLE ejf_section ADD headAdCode CLOB;
ALTER TABLE ejf_section ADD footAdCode CLOB;

ALTER TABLE ejf_board ADD isCatOK CHAR(1) DEFAULT 'F';
ALTER TABLE ejf_board ADD listType VARCHAR2(10);
ALTER TABLE ejf_board ADD cats VARCHAR2(255);
ALTER TABLE ejf_board ADD members CLOB;
ALTER TABLE ejf_board ADD topicAdCode CLOB;
ALTER TABLE ejf_board ADD scoreType CHAR(1) DEFAULT 'N';
ALTER TABLE ejf_board ADD iconFile VARCHAR2(100);

ALTER TABLE ejf_topic ADD catID NUMBER(4) DEFAULT 0;
ALTER TABLE ejf_topic MODIFY highColor VARCHAR2(8);
ALTER TABLE ejf_topic ADD specType CHAR(1) DEFAULT 'N';
ALTER TABLE ejf_topic ADD diggups NUMBER(10) DEFAULT 0;
ALTER TABLE ejf_topic ADD diggdns NUMBER(10) DEFAULT 0;

ALTER TABLE ejf_archive_topic ADD catID NUMBER(4) DEFAULT 0;
ALTER TABLE ejf_archive_topic MODIFY highColor VARCHAR2(8);
ALTER TABLE ejf_archive_topic ADD specType CHAR(1) DEFAULT 'N';
ALTER TABLE ejf_archive_topic ADD diggups NUMBER(10) DEFAULT 0;
ALTER TABLE ejf_archive_topic ADD diggdns NUMBER(10) DEFAULT 0;

CREATE INDEX ejf_topic_list ON ejf_topic (boardID,sectionID,state,topScope,catID);

CREATE TABLE ejf_tags (
    tagname         VARCHAR2(20)    NOT NULL,
    queryCount      NUMBER(10)      DEFAULT 1,
    recordCount	    NUMBER(10)      DEFAULT 0,
    createTime      DATE,
    updateTime      TIMESTAMP,
    PRIMARY KEY (tagname));
    
CREATE TABLE ejf_feed_stat (
    boardID         VARCHAR2(10)    NOT NULL,
    visits          NUMBER(10)      DEFAULT 1,
    createTime      DATE,
    PRIMARY KEY(boardID));
    
CREATE TABLE ejf_vote(
    topicID         NUMBER(10)      NOT NULL,
    options    		CLOB			NOT NULL,
    voters 	        CLOB		    ,
    isPublic		CHAR(1) 		DEFAULT 'T',
    isSingle		CHAR(1) 		DEFAULT 'T',
	expireDate		DATE			,
    FOREIGN KEY(topicID)
        REFERENCES ejf_topic(topicID) ON DELETE CASCADE);
        
CREATE TABLE ejf_voting(
    topicID         NUMBER(10)		NOT NULL,
    optID			NUMBER(2) 		NOT NULL,
    optCount		NUMBER(10) 		DEFAULT 0,
    updateTime      TIMESTAMP,
    FOREIGN KEY(topicID)
        REFERENCES ejf_topic(topicID) ON DELETE CASCADE);

CREATE TABLE ejf_deposit(
    userID          VARCHAR(15)     NOT NULL,
    createTime      DATE	 		NOT NULL,
    deposit         NUMBER(10)      DEFAULT 0);
